/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsConnection;
import com.ibm.hsc.filesvr.FsException;
import com.ibm.hsc.filesvr.FsPacket;
import com.ibm.hsc.filesvr.FsSystem;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.DateFormat;
import java.util.Date;

public class FsServer
extends FsConnection {
    public static final int FILE_SERVER_PORT = 2125;

    public static void main(String[] stringArray) {
        FsSystem.processArgs(stringArray);
        if (FsSystem.isTraceOn()) {
            System.out.println("File Server listening on port 2125 at " + DateFormat.getDateTimeInstance(3, 2).format(new Date()));
        }
        try {
            ServerSocket serverSocket = new ServerSocket(2125);
            while (true) {
                Socket socket = serverSocket.accept();
                new FsServer(socket).start();
            }
        }
        catch (Exception exception) {
            System.out.println("FsServer.main: Exception caught");
            exception.printStackTrace();
            return;
        }
    }

    public FsServer(Socket socket) throws FsException {
        super(socket);
        this.trace("FsServer.main: connection received");
    }

    public void run() {
        while (this.isOpen()) {
            try {
                this.trace("FsServer.run: waiting for a packet");
                FsPacket fsPacket = this.readPacket();
                if (fsPacket == null) continue;
                this.trace("FsServer.run: building response to packet received");
                FsPacket fsPacket2 = fsPacket.getResponsePacket();
                if (fsPacket2 != null) {
                    this.writePacket(fsPacket2);
                    continue;
                }
                this.trace("FsServer.run: no valid response to packet found");
            }
            catch (FsException fsException) {
                if (fsException.getId() == 513) break;
                this.trace("FsServer.run: Exception caught", fsException);
            }
        }
        this.close();
        this.trace("FsServer.run: connection closed\n\n");
    }
}

